import arcpy
import os

def main(target_workspace, source_gdb, huc_code):
    new_gdb_name = "WBD_Current.gdb"
    new_gdb_path = os.path.join(target_workspace, new_gdb_name)

    if not arcpy.Exists(new_gdb_path):
        arcpy.CreateFileGDB_management(target_workspace, new_gdb_name)

    # Source feature classes
    wbdhu8_fc = os.path.join(source_gdb, "WBDHU8")
    wbdhu10_fc = os.path.join(source_gdb, "WBDHU10")
    wbdhu12_fc = os.path.join(source_gdb, "WBDHU12")
    wbdline_fc = os.path.join(source_gdb, "WBDLine")

    # Output paths
    wbdhu8_out = os.path.join(new_gdb_path, "WBDHU8_Current")
    wbdhu10_out = os.path.join(new_gdb_path, "WBDHU10_Current")
    wbdhu12_out = os.path.join(new_gdb_path, "WBDHU12_Current")
    wbdline_out = os.path.join(new_gdb_path, "WBDLine_Current")

    # Select and export WBDHU8
    arcpy.MakeFeatureLayer_management(wbdhu8_fc, "wbdhu8_layer", f"HUC8 = '{huc_code}'")
    arcpy.CopyFeatures_management("wbdhu8_layer", wbdhu8_out)

    # Select and export WBDHU10
    arcpy.MakeFeatureLayer_management(wbdhu10_fc, "wbdhu10_layer", f"HUC10 LIKE '{huc_code}%'")
    arcpy.CopyFeatures_management("wbdhu10_layer", wbdhu10_out)

    # Select and export WBDHU12
    arcpy.MakeFeatureLayer_management(wbdhu12_fc, "wbdhu12_layer", f"HUC12 LIKE '{huc_code}%'")
    arcpy.CopyFeatures_management("wbdhu12_layer", wbdhu12_out)

    # Select and export WBDLine intersecting WBDHU12
    arcpy.MakeFeatureLayer_management(wbdline_fc, "wbdline_layer")
    arcpy.SelectLayerByLocation_management("wbdline_layer", "INTERSECT", wbdhu12_out)
    arcpy.CopyFeatures_management("wbdline_layer", wbdline_out)

# Script tool entry point
if __name__ == "__main__":
    target_workspace = arcpy.GetParameterAsText(0)
    source_gdb = arcpy.GetParameterAsText(1)
    huc_code = arcpy.GetParameterAsText(2)
    main(target_workspace, source_gdb, huc_code)