# WBD QC Tools
This project consists of a scripts to QC WBD attributes and geometry prior to submitting data to the national data set.


## Introduction
These tools were developed by the personnel of the WBD team (Patrick Longley, Brittany Gold, and Matthew Morriss at the UT Water Science Center). They are largely written in ArcPy for use with ArcMap or ArcPro. As these two softwares use different versions of Python (2.x and 3.x respectively), we have tested these tools on both softwares.

All of these tools are packaged into a .pyt - python toolbox - which can be added to both ArcPro and ArcMap.  The tools are package into a toolbox called **WBD automation tools**.

## List of tools
These tools were developed separately but are incorporated into a single Arc Pro/Map Toolbox. WIthin this toolbox, the tools are structured in a thoughtful and sensible way, following the order of operations likely for the end user. 

Below is a longer description of all of the tools:

1. `Download Data` - Folder containing tools to download elevation, NHD, and WBD data
    * `Download 3DEP data` - download 3dep elevation data for given HUCs
    * `Download GNIS data` - download GNIS data for given state
    * `Download NHD data` - download NHD data for given HUCs
    * `Download WBD data` - download WBD data for given HUCS
    * `Download workflow` - link 3DEP, NHD, and WBD downloads
	* `Package data` - packages 3DEP, NHD, and WBD data into a prep folder


2. `Elevation Derived Hydrography` 
	* `Create Polygons` - Creates archydro file structure and polygons
	
	
3. `Geometry Checks` - Secondary QC to look for geometry or topography induced errors
	* `G1 Walled Fill` - Walls DEM and finds where flow is impeded or altered
	* `Area Change/HUC Check`- Calculates area changed by updates to WBD
	* `Check Snapping` - Checks that WBD is snapped to NHD
	* `Create Topology` - Creates topology using the updated WBD line feature class
	* `Low Relief Finder` - Identifies areas of low-relief and outputs a polygon of low-relief areas for user to check


4. `Attribution`
	* `General Check` - general check of all fields edited during EDH process
	* `Line: transfer fields` - Transfers TNMID, HUMod, and Linesource from original WBD Line featureclass to updated WBD line featureclass
	* `Polygon: toHuc/HUType-check/fill` - When ToHuc or HUType is empty, this tool fills it in
	* `Polygon: Name-check` - Checks that WBD polygons are correctly named
	* `Polygon: Name-update` - Uses fields from Name-check to suggest new names for incorrectly named watersheds
	* `Polygon: GNISReference_IDs-check/fill` - When GNISReference_IDs field is empty this tool populates these fields.
	
5. `Archive`
	* `Fill Depth and Polygon` - Formerly in "Geometry Checks." Calculates depth of fill in DEM and outputs polygon of filled areas