"""
1) Handle lines manually (could automate these steps minus edgemeatching)
    - select by attribute to select polygons (12s/14s/16s) for the updated HUC.
    - select lines by location using above features
    - delete selected lines
    - copy in new lines
    - edge match lines
2) Script
    - create featurelayer of polygons that were updated
    - create featurelayer of polygons that weren't updated
    - select non-updated polygons that share a line segment with the updated polygons >>> buffer
    - delete updated polygons
    - replace polygons with updated version
    - buffer polygons to label points.
    - lines to polygons (using label points)>>> geometry featureclass (includes bonus  polygons)
    - create tnmid: shape dictionary (no blank tnmids removes extra polygons)
    - Loop thorugh polygon featureclass and update shape field using dictionary
    - prosper
    
"""
    
import arcpy

# datasets
arcpy.env.workspace = r'C:\Users\plongley\Desktop\19080305_check\19080305_check.gdb'
# POLYGONS = 'WBDHU10'
# UPDATED_BUFFER = 'hu10_buffer_updatedgeometry'
POLYGONS = 'WBDHU12'
UPDATED_BUFFER = 'hu12_buffer_updatedgeometry'

shape_dict = {}
with arcpy.da.SearchCursor(UPDATED_BUFFER, ['tnmid', 'SHAPE@']) as cursor:
    for row in cursor:
        shape_dict[row[0]] = row[1]

with arcpy.da.UpdateCursor(POLYGONS, ['tnmid', 'SHAPE@']) as cursor:
    for row in cursor:
        try:
            row[1] = shape_dict[row[0]]
            cursor.updateRow(row)
            print(row)
        except KeyError:
            pass




