from setuptools import setup, find_packages

with open('README.MD') as f:
    readme = f.read()

with open('LICENSE.rst') as f:
    license_doc = f.read()

setup(
    name='wbd_automation',
    version='0.12.3',
    description='Tools for automating work with the Watershed Boundary Dataset',
    long_description=readme,
    author='Brittany Gold, Patrick Longley, and Matthew Morris',
    author_email='bgold@usgs.gov, plongley@usgs.gov, mmorriss@usgs.gov',
    url='https://code.usgs.gov/bgold/wbd-qc-tools',
    license=license_doc,
    package_dir={'': 'src'},  # directory where pacakages are saved. '' stands for the root diretory (where setup.py is saved.)
    packages=['wbd_automation'],
    package_data={
        '': [                  # ''  used since package specified
            'esri/toolboxes/*',
            'esri/arcpy/*',
            'esri/help/gp/*',
            'esri/help/gp/toolboxes/*',
        ]
    },
)