"""
 Toolbox Name:  WBD_automation_toolbox
 Description: Toolbox for automating common WBD tasks.
 Author: Patrick Longley (plongley@usgs.gov)
 Created: 08/11/2020
 Language: Written in python3 (arcpro). Some tools moddified to also work python2 (arcmap).
 History:
"""

import arcpy
import sys
import os

scripts_dir = os.path.dirname(os.path.dirname(__file__))
sys.path.append(scripts_dir)

from version import __version__

PYTHON_VERSION = sys.version_info.major

# PYTHON2/3 TOOLS
# Attribution tools
from attribution_referencegnis_ids import (
    ReferenceGNISISID as attribution_referencegnisid,
)
from attribution_tohuc_hutype import TohucHutype as attribution_tohuchutype

# from attribution_lines_transferfields import TransferFields as attribution_transferfields
from attribution_linescheck import LinesCheck as attribution_linescheck
from attribution_namecheck import NameCheck as attribution_namecheck
from attribution_nameupdate import NameUpdate as attribution_nameupdate
from attribution_generalcheck import GeneralCheck as attribution_generalcheck
from attribution_hudigit import HUDigit as attribution_hudigit

# Download_tools
from download_3dep import Download3DEP as download_3dep
from download_gnis import DownloadGNIS as download_gnis
from download_nhd import DownloadNHD as download_nhd

# from download_packagedata import PackageData as download_packagedata
from download_wbd import DownloadWBD as download_wbd
from download_workflow import DownloadWorkflow as download_workflow

# Geometry tools
from geometry_areachange import AreaChange as geometry_areachange
from geometry_checksnapping import CheckSnapping as geometry_checksnapping
from geometry_fillpolygon import Fill_polygon as geometry_fillpolygon
from geometry_lowrelief import Low_relief_finder as geometry_lowrelief

# Job tools
from job_edgematchpolygons import EdgeMatchPolygons as job_edgematchpolygons

tools = [
    attribution_referencegnisid,
    attribution_tohuchutype,
    # attribution_transferfields,
    attribution_linescheck,
    attribution_namecheck,
    attribution_nameupdate,
    attribution_generalcheck,
    attribution_hudigit,
    download_3dep,
    download_gnis,
    download_nhd,
    # download_packagedata,
    download_wbd,
    download_workflow,
    geometry_areachange,
    geometry_checksnapping,
    geometry_lowrelief,
    geometry_fillpolygon,
    job_edgematchpolygons,
]

# PYTHON 3 TOOLS
if PYTHON_VERSION == 3:
    # Geometry tools
    from geometry_createtopology import CreateTopology

    # EDH tools
    from edh_createpolygons import CreatePolygons
    from geometry_walled_fill import WalledFill
    from geometry_boundary_near_hydro import HydroNearBoundary

    tools.extend(
        [
            CreateTopology,
            CreatePolygons,
            WalledFill,
            HydroNearBoundary,
        ]
    )
    # ARCHydro tools
    if arcpy.ListToolboxes("ArcHydro*"):
        try:
            from edh_subwatershedlines import SubwatershedLines as edh_subwatershedlines
            from edh_terrain_preprocessing import (
                TerrainPreprocessing as edh_terrainpreprocessing,
            )

            tools.extend([edh_subwatershedlines, edh_terrainpreprocessing])
        except:
            pass


class Toolbox(object):
    def __init__(self):
        """
        This toolbox contains four toolsets: 1) Attribution, 2) Download data, Elevation derived hydrography, and
        3) Geometry checks.
        """
        self.label = "WBD automation tools"
        self.alias = "wbd"
        self.label = f"WBD automation tools v{__version__}"
        self.alias = f"wbd{__version__.replace('.', '').replace('_', '')}"
        self.tools = tools
