import os
ACRES_TO_KM2 = 0.00404686

F_TNMID = 'tnmid'
# WBD line feature class field names
F_HUDIGIT = 'hudigit'
F_LINESOURCE = 'linesource'
F_HUMOD = 'humod'
F_HUCA = 'huca'
F_HUCB = 'hucb'
# WBD polygon feature class field names
F_HUC2 = 'huc2'
F_HUC4 = 'huc4'
F_HUC6 = 'huc6'
F_HUC8 = 'huc8'
F_HUC10 = 'huc10'
F_HUC12 = 'huc12'
F_HUC14 = 'huc14'
F_HUC16 = 'huc16'
F_NAME = 'name'
F_TOHUC = 'tohuc'
F_REFERENCEGNIS_IDS = 'referencegnis_ids'
F_STATES = 'states'
F_HUTYPE = 'hutype'
F_AREASQKM = 'areasqkm'
F_AREACRES = 'areaacres'
F_NONTRIBUTINGAREASQKM = 'noncontributingareasqkm'
F_NONTRIBUTINGAREAACRES = 'noncontributingareaacres'
# NHD flowline featureclass field names
F_FTYPE = 'FType'
F_GNIS_NAME = 'gnis_name' #modified this from 'GNIS_Name' to the new data model of lowercase field names.
# GNIS featureclass field names
F_FEATURE_ID = 'FEATURE_ID'
F_FEATURE_NAME = 'FEATURE_NAME'
# Issue table field names
F_ISSUE = 'issue'
F_MAJORFEATURE = 'major_feature'
F_MINORFEATURE = 'minor_feature'
F_FRONTALFEATURE = 'frontal_feature'
F_POTENTIALNAMES = 'potential_names'
F_PREFIX ='prefix'
F_PREFIXTEMP = 'prefix_temp'
# Constants
HUC = 'huc'
LOWER = 'Lower'
MIDDLE = 'Middle'
UPPER = 'Upper'
HEADWATERS = 'Headwaters'
OUTLET = 'Outlet'
# EDH file names
FAC = 'Fac'
STR = 'Str'
STRORDER = 'StrOrder'
EDITPOINT = 'EditPoint'
FDRSTR = 'FdrStr'
STRLNK = 'StrLnk'
DRAINAGELINE = 'DrainageLine'
DRAINAGELINE_FS = 'DrainageLine_FS'
AGREEDEM = 'AgreeDEM'
WALLEDDEM = 'WalledDEM'
FIL = 'Fil'
FDR = 'Fdr'
FDRSTRADJ = 'FdrStrAdj'
CAT = 'Cat'
CATCHMENT = 'Catchment'
ADJOINTCATCHMENT = 'AdjointCatchment'
CATCHMENT_FS = 'Catchment_FS'
SUBWATERSHED = 'Subwatershed'
SUBWATERSHEDPOINTS = 'SubwatershedPoints'
SUBWATERSHEDBACKUP = 'SubwatershedBackup'
SUBWATRESHEDLINE = 'SubwatershedLine'
SUBWATERSHEDPAEK10 = 'SubwatershedPaek10'
SUBWATERSHEDPOINTREMOVE5 = 'SubwatershedPointRemove5'
CATCHMENTLINE = 'CatchmentLine'
CATCHMENTPAEK10 = 'CatchmentPaek10'
CATCHMENTPOINTREMOVE5 = 'CatchmentPointRemove5'
NEWLINES = 'NewLines'
LINETOPOLOGY = 'WBDTopology'
POLYGONTOPOLOGY = 'WBDTopology'

FLAG_SUFFIX = '_flag'
CALC_SUFFIX = '_calc'
FLAG_LENGTH = 256
# These flags can be changed, but they should be kept in alphabetic order (max function is used all over).
CORRECT_FLAG = 'CORRECT'
FILLED_FLAG = 'FILLED'
NOTCHECKED_FLAG = 'NOTCHECKED'
WRONG_FLAG = 'INCORRECT'
NODATA_FLAG = 'NODATA'
# state abbreviations
abbrev_dict = {
    'Alabama': 'AL',
    'Alaska': 'AK',
    'American Samoa': 'AS',
    'Arizona': 'AZ',
    'Arkansas': 'AR',
    'California': 'CA',
    'Colorado': 'CO',
    'Connecticut': 'CT',
    'Delaware': 'DE',
    'District of Columbia': 'DC',
    'Florida': 'FL',
    'Georgia': 'GA',
    'Guam': 'GU',
    'Hawaii': 'HI',
    'Idaho': 'ID',
    'Illinois': 'IL',
    'Indiana': 'IN',
    'Iowa': 'IA',
    'Kansas': 'KS',
    'Kentucky': 'KY',
    'Louisiana': 'LA',
    'Maine': 'ME',
    'Maryland': 'MD',
    'Massachusetts': 'MA',
    'Michigan': 'MI',
    'Minnesota': 'MN',
    'Mississippi': 'MS',
    'Missouri': 'MO',
    'Montana': 'MT',
    'Nebraska': 'NE',
    'Nevada': 'NV',
    'New Hampshire': 'NH',
    'New Jersey': 'NJ',
    'New Mexico': 'NM',
    'New York': 'NY',
    'North Carolina': 'NC',
    'North Dakota': 'ND',
    'Northern Mariana Islands':'MP',
    'Ohio': 'OH',
    'Oklahoma': 'OK',
    'Oregon': 'OR',
    'Pennsylvania': 'PA',
    'Puerto Rico': 'PR',
    'Rhode Island': 'RI',
    'South Carolina': 'SC',
    'South Dakota': 'SD',
    'Tennessee': 'TN',
    'Texas': 'TX',
    'Utah': 'UT',
    'Vermont': 'VT',
    'Virgin Islands': 'VI',
    'Virginia': 'VA',
    'Washington': 'WA',
    'West Virginia': 'WV',
    'Wisconsin': 'WI',
    'Wyoming': 'WY',
}
# REGEX for fields
EMPTY_REGEX = r'^(None|\s|)$'
BASE_REGEX = r'^({},)*({})$'
REGEX_TNMID = r'^{([0-9A-Z]){8}-([0-9A-Z]){4}-([0-9A-Z]){4}-([0-9A-Z]){4}-([0-9A-Z]){12}}$'
REGEX_HUC = r'^([01][1-9]|2[01])([0-9]{{2}}){{{}}}$'
REGEX_TOHUC = r'^(([01][1-9]|2[01])([0-9]{{2}}){{{}}}|OCEAN|CAN|MX)$'
REGEX_NAME = r'^\S[0-9a-zA-Z- ]+\S$'
state_list = list(abbrev_dict.values())
REGEX_STATES = BASE_REGEX.format(
    ',|'.join(state_list),
    '|'.join(state_list)
)
REGEX_HUTYPE = r'^(S|C|F|M|W|I)$'
humod_list_polygon = ['AW','GF','GL','IF','KA','LA','MA','NC','NM','OC','OF','PD','RC','RS','UA','WD']
REGEX_HUMOD_POLYGON = BASE_REGEX.format(
    ',|'.join(humod_list_polygon),
    '|'.join(humod_list_polygon)
)
humod_list_line = ['AW','DM','LA','LE','MA','NM','OC','OF','PD','PL','PS','SI','SL','TF','UA']
REGEX_HUMOD_LINE = BASE_REGEX.format(
    ',|'.join(humod_list_line),
    '|'.join(humod_list_line)
)
REGEX_GNISID = r'^([1-9][0-9]+,)?[1-9][0-9]+$'
linesource_list = [
    r'BATH[1-9][0-9]*',
    r'Buffer[1-9][0-9]*[MFN]',
    r'CAN50',
    r'CAN250',
    r'CDED50',
    r'CDED250',
    r'DEDEM10',
    r'DEDEM30',
    r'DEM10',
    r'DEM15',
    r'DEM30',
    r'DRG24',
    r'DRG25',
    r'DRG63',
    r'EDNA30',
    r'IFSAR[1-9][0-9]*M((19|20)[0-9]{2})+',
    r'GPS',
    r'NED30',
    r'NO-AA3NM',
    r'EDNA30',
    r'HYPSO[1-9][0-9]*',
    r'LIDAR[1-9][0-9]*M((19|20)[0-9]{2})+',
    r'MEX50',
    r'MEXTOPO',
    r'NAIP(19|20)[0-9]{2}'
    r'NED10',
    r'NED30',
    r'NHD24',
    r'NHD24',
    r'NHD25',
    r'NHD63',
    r'NHD100',
    r'NHN10',
    r'NHN20',
    r'NHN50',
    r'NOAA3M',
    r'NRN',
    r'ORTHO[1-9][0-9]*',
    r'OTH',
    r'(AB|BC|MB|NB|NL|NT|NS|NU|ON|PE|QC|SK|YT)[1-9][0-9]*'
    r'SPOT(19|20)[0-9]{2}',
    r'TOPO24',
    r'TOPO25',
    r'TOPO50',
    r'TOPO63',
    r'TOPO250',
    r'TRIM',
]
REGEX_LINESOURCE = BASE_REGEX.format(
    ',|'.join(linesource_list),
    '|'.join(linesource_list)
)
# template filepaths
BASE_FOLDER = os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
TEMPLATE_FOLDER = os.path.join(BASE_FOLDER, 'schemas', 'New_WBD_Template_alb.gdb\WBD')
HUC8_TEMPLATE = os.path.join(TEMPLATE_FOLDER, 'WBDHU8')
HUC10_TEMPLATE = os.path.join(TEMPLATE_FOLDER, 'WBDHU10')
HUC12_TEMPLATE = os.path.join(TEMPLATE_FOLDER, 'WBDHU12')
HUC14_TEMPLATE = os.path.join(TEMPLATE_FOLDER, 'WBDHU14')
HUC16_TEMPLATE = os.path.join(TEMPLATE_FOLDER, 'WBDHU16')
WBDLINE_TEMPLATE = os.path.join(TEMPLATE_FOLDER, 'WBDLine')