"""
 Description:  ARC parameters
 Author:    Patrick Longley  (plongley@usgs.gov)
 Created:   08/19/2020
 Language: python3/python2
 History:
"""

import os
import getpass
import arcpy
import wbd_c

# Old WBD polygon featureclass
polygonfc_old = arcpy.Parameter(
    displayName="Old WBD polygon feature class",
    name="polygonfc_old",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Input",
)
polygonfc_old.filter.list = ["POLYGON"]

# Updated WBD polygon featureclass
polygonfc_updated = arcpy.Parameter(
    displayName="Updated WBD polygon feature class",
    name="polygonfc_updated",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Input",
)
polygonfc_updated.filter.list = ["POLYGON"]

# Updated WBD polygon featureclass (multiple)
polygonfcs_updated = arcpy.Parameter(
    displayName="Updated WBD polygon featureclass(es)",
    name="polygonfcs_updated",
    datatype="GPFeatureLayer",
    parameterType="Optional",
    direction="Input",
    multiValue=True,
)
polygonfc_updated.filter.list = ["POLYGON"]

# job WBD polygon feature class
polygonfc_job = arcpy.Parameter(
    displayName="Job checkout WBD polygon feature class",
    name="polygonfc_job",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Input",
)
polygonfc_job.filter.list = ["POLYGON"]

# job WBD line feature class
linefc_job = arcpy.Parameter(
    displayName="Job checkout WBD line feature class",
    name="linefc_job",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Input",
)
linefc_job.filter.list = ["LINE"]

# Old WBD line featureclass
linefc_old = arcpy.Parameter(
    displayName="Old WBD line feature class",
    name="linefc_old",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Input",
)
linefc_old.filter.list = ["LINE"]

# Update WBD  line featureclass
linefc_updated = arcpy.Parameter(
    displayName="Updated WBD line feature class",
    name="linefc_updated",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Input",
)
linefc_updated.filter.list = ["LINE"]

# NHD line featureclass
nhdline_fc = arcpy.Parameter(
    displayName="NHD flowline feature class",
    name="nhdline_fc",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Input",
)
nhdline_fc.filter.list = ["LINE"]

# NHD water body featureclass
nhdwaterbody_fc = arcpy.Parameter(
    displayName="NHD waterbody feature class",
    name="nhdwaterbody_fc",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Input",
)
nhdwaterbody_fc.filter.list = ["POLYGON"]

# NHD area featureclass
nhdarea_fc = arcpy.Parameter(
    displayName="NHD area feature class",
    name="nhdarea_fc",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Input",
)
nhdarea_fc.filter.list = ["POLYGON"]

# NHD snapping issues
nhdsnapping_issues = arcpy.Parameter(
    displayName="NHD snapping issues output",
    name="nhdsnapping_issues",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Output",
)

# GNIS feature class
gnis_fc = arcpy.Parameter(
    displayName="GNIS feature class",
    name="gnis_fc",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Input",
)
gnis_fc.filter.list = ["POINT"]

# Incorrect name
incorrect_name = arcpy.Parameter(
    displayName="Incorrectly named watershed",
    name="incorrect_name",
    datatype="GPString",
    parameterType="Required",
    direction="Input",
)
incorrect_name.filter.list = []

# Custom new name
custom_newname = arcpy.Parameter(
    displayName="Custom new name",
    name="custom_newname",
    datatype="GPString",
    parameterType="Optional",
    direction="Input",
)

# Reccomended names
reccomended_name = arcpy.Parameter(
    displayName="Reccomended new name",
    name="reccomended_name",
    datatype="GPString",
    parameterType="Optional",
    direction="Input",
)
reccomended_name.filter.list = []

# Keep name
keep_oldname = arcpy.Parameter(
    displayName="Keep old name",
    name="keep_oldname",
    datatype="GPBoolean",
    parameterType="Optional",
    direction="Input",
)
keep_oldname.value = False

# Include artificial
include_artificial = arcpy.Parameter(
    displayName="Include ditches and canals in flowline fc?",
    name="include_artificial",
    datatype="GPBoolean",
    parameterType="Required",
    direction="Input",
)
include_artificial.value = True

# Fill missing values
fill_missing = arcpy.Parameter(
    displayName="Fill missing values?",
    name="fill_missing",
    datatype="GPBoolean",
    parameterType="Required",
    direction="Input",
)
fill_missing.value = False

# Add columns for name update
add_updatecolumns = arcpy.Parameter(
    displayName="Add columns for name update?",
    name="add_updatecolumns",
    datatype="GPBoolean",
    parameterType="Required",
    direction="Input",
)
fill_missing.value = False

# Spatial reference
spatial_reference = arcpy.Parameter(
    displayName="Spatial reference",
    name="spatial_reference",
    datatype="GPSpatialReference",
    parameterType="Optional",
    direction="Input",
)

# 3DEP dataset
dataset_3dep = arcpy.Parameter(
    displayName="3DEP dataset",
    name="dataset_3dep",
    datatype="GPString",
    parameterType="Optional",
    direction="Input",
)
dataset_3dep.filter.list = [
    "National Elevation Dataset (NED) 1/3 arc-second",
    "National Elevation Dataset (NED) 1 arc-second",
    "Alaska IFSAR 5 meter DEM",
]
dataset_3dep.value = None

# Buffer distance
buffer_dist = arcpy.Parameter(
    displayName="Buffer distance (optional)",
    name="buffer_dist",
    datatype="GPString",
    parameterType="Optional",
    direction="Input",
)
buffer_dist.value = "4000 Meters"

# Contour spacing
contour_spacing = arcpy.Parameter(
    displayName="Contour spacing (m)",
    name="contour_spacing",
    datatype="GPLong",
    parameterType="Optional",
    direction="Input",
)

# HUC (python 3)
huc_py3 = arcpy.Parameter(
    displayName="HUC(s)",
    name="huc",
    datatype="GPString",
    parameterType="Required",
    direction="Input",
    multiValue=True,
)

# HUC (python 2)
huc_py2 = arcpy.Parameter(
    displayName="HUC(s) (separated by semicolons)",
    name="huc",
    datatype="GPString",
    parameterType="Required",
    direction="Input",
)

# Single HUC
single_huc = arcpy.Parameter(
    displayName="HUC",
    name="single_huc",
    datatype="GPString",
    parameterType="Required",
    direction="Input",
)

# Input DEM
dem_in = arcpy.Parameter(
    displayName="DEM",
    name="dem_in",
    datatype="DERasterDataset",
    parameterType="Required",
    direction="Input",
)

# WBD feature dataset
wbd_fd = arcpy.Parameter(
    displayName="WBD feature dataset (reprojected)",
    name="wbd_fd",
    datatype="DEFeatureDataset",
    parameterType="Required",
    direction="Input",
)

# NHD feature dataset
nhd_fd = arcpy.Parameter(
    displayName="NHD feature dataset (reprojected)",
    name="nhd_fd",
    datatype="DEFeatureDataset",
    parameterType="Required",
    direction="Input",
)

# Output DEM (derived)
dem_out = arcpy.Parameter(
    displayName="Output DEM",
    name="dem_out",
    datatype="DERasterDataset",
    parameterType="Derived",
    direction="Output",
)

# Output NHD flowline (derived)
flowline_out = arcpy.Parameter(
    displayName="Output flowline",
    name="flowline_out",
    datatype="GPFeatureLayer",
    parameterType="Derived",
    direction="Output",
)

# Output NHD area (derived)
area_out = arcpy.Parameter(
    displayName="Output area",
    name="area_out",
    datatype="GPFeatureLayer",
    parameterType="Derived",
    direction="Output",
)

# Output NHD waterbody (derived)
waterbody_out = arcpy.Parameter(
    displayName="Output waterbody",
    name="waterbody_out",
    datatype="GPFeatureLayer",
    parameterType="Derived",
    direction="Output",
)

# Output WBD line (derived)
wbdline_out = arcpy.Parameter(
    displayName="Output wbd_line",
    name="wbdline_out",
    datatype="GPFeatureLayer",
    parameterType="Derived",
    direction="Output",
)

# State names (python 3)
state_list = [
    "Alabama",
    "Alaska",
    "Arizona",
    "Arkansas",
    "California",
    "Colorado",
    "Connecticut",
    "Delaware",
    "Florida",
    "Georgia",
    "Hawaii",
    "Idaho",
    "Illinois",
    "Indiana",
    "Iowa",
    "Kansas",
    "Kentucky",
    "Louisiana",
    "Maine",
    "Maryland",
    "Massachusetts",
    "Michigan",
    "Minnesota",
    "Mississippi",
    "Missouri",
    "Montana",
    "Nebraska",
    "Nevada",
    "New Hampshire",
    "New Jersey",
    "New Mexico",
    "New York",
    "North Carolina",
    "North Dakota",
    "Ohio",
    "Oklahoma",
    "Oregon",
    "Pennsylvania",
    "Rhode Island",
    "South Carolina",
    "South Dakota",
    "Tennessee",
    "Texas",
    "Utah",
    "Vermont",
    "Virginia",
    "Washington",
    "West Virginia",
    "Wisconsin",
    "Wyoming",
]
statenames_py3 = arcpy.Parameter(
    displayName="State(s)",
    name="state_names",
    datatype="GPString",
    parameterType="Required",
    direction="Input",
    multiValue=True,
)
statenames_py3.filter.list = state_list

# State names (python 2)
statenames_py2 = arcpy.Parameter(
    displayName="State",
    name="state_names",
    datatype="GPString",
    parameterType="Required",
    direction="Input",
)
statenames_py2.filter.list = state_list

# GNIS gdb
gnis_gdb = arcpy.Parameter(
    displayName="GNIS geodatabase",
    name="gnis_gdb",
    datatype="DEFolder",
    parameterType="Required",
    direction="Input",
)

# Output folder
out_folder = arcpy.Parameter(
    displayName="Output Folder",
    name="out_folder",
    datatype="DEFolder",
    parameterType="Required",
    direction="Input",
)
out_folder.value = os.path.join(r"C:\Users", getpass.getuser(), "Downloads")

# Output feature class
out_fc = arcpy.Parameter(
    displayName="Output Feature Class",
    name="out_fc",
    datatype="DEFeatureClass",
    parameterType="Required",
    direction="Output",
)

# Output geodatabase
output_gdb = arcpy.Parameter(
    displayName="Output geodatabase",
    name="output_gdb",
    datatype="DEWorkspace",
    parameterType="Required",
    direction="Input",
)
output_gdb.filter.list = ["Local Database"]

# Inner walls
inner_walls = arcpy.Parameter(
    displayName="Internal wall feature class (optional)",
    name="internal_walls",
    datatype="GPFeatureLayer",
    parameterType="Optional",
    direction="Input",
)
inner_walls.filter.list = ["POLYGON", "LINE"]

# Outer Walls
outer_walls = arcpy.Parameter(
    displayName="External wall feature class (optional)",
    name="outer_walls",
    datatype="GPFeatureLayer",
    parameterType="Optional",
    direction="Input",
)
outer_walls.filter.list = ["POLYGON"]

# Batch Points
batch_points = arcpy.Parameter(
    displayName="Batch point feature class",
    name="batch_points",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Input",
)
batch_points.filter.list = ["POINT"]

# Flow direction raster
fdr = arcpy.Parameter(
    displayName="Flow direction raster",
    name="fdr",
    datatype="DERasterDataset",
    parameterType="Required",
    direction="Input",
)

# Flow direction raster
str_ras = arcpy.Parameter(
    displayName="Stream raster",
    name="str_ras",
    datatype="DERasterDataset",
    parameterType="Required",
    direction="Input",
)

# Catchment feature class
catchment = arcpy.Parameter(
    displayName="Catchment feature class (optional)",
    name="catchement",
    datatype="GPFeatureLayer",
    parameterType="Optional",
    direction="Input",
)
catchment.filter.list = ["POLYGON"]

# WBD polygon feature class (multivalue=True, Optional)
updatedpolygons_fc = arcpy.Parameter(
    displayName="WBD polygons",
    name="updatedpolygons_fc",
    datatype="GPFeatureLayer",
    parameterType="Optional",
    direction="Input",
    multiValue=True,
)
updatedpolygons_fc.filter.list = ["POLYGON"]

# WBD polygon labelpnt
wbdpolygon_labelpnt = arcpy.Parameter(
    displayName="WBD polygon label point feature class",
    name="wbdpolygon_labelpnt",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Input",
    multiValue=True,
)
wbdpolygon_labelpnt.filter.list = ["POINT"]

# Fields to transfer
linefields_tocheck = arcpy.Parameter(
    displayName="Fields to check",
    name="linefields_tocheck",
    datatype="GPString",
    parameterType="Required",
    direction="Input",
    multiValue=True,
)
linefields_tocheck.filter.list = [
    wbd_c.F_TNMID,
    wbd_c.F_HUMOD,
    wbd_c.F_HUDIGIT,
    wbd_c.F_LINESOURCE,
]
linefields_tocheck.value = [wbd_c.F_TNMID, wbd_c.F_HUMOD, wbd_c.F_HUDIGIT]

# Outlets
outlets = arcpy.Parameter(
    displayName="Outlets",
    name="outlets",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Output",
)

# Frontal outlets
frontal_outlets = arcpy.Parameter(
    displayName="Frontal outlets",
    name="frontal_outlets",
    datatype="GPFeatureLayer",
    parameterType="Required",
    direction="Output",
)

# New subdivisions
new_subdivisions = arcpy.Parameter(
    displayName="New subdivisions?",
    name="new_subdivisions",
    datatype="GPBoolean",
    parameterType="Required",
    direction="Input",
)
new_subdivisions.value = False
